
int alpha = PREFIX(alpha);
float intensity = float(alpha)/100.0;
#define ChannelBlend_Exclusion(B,L)  ((B + L - ((B * L)*2.0)))

vec3 AdjustforJigsaw_Spring(vec3 rgb) // YELLOW
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x,86.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y,2.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z,2.0/256.0);
	return outputCol;
}
vec3 AdjustforJigsaw_Summer(vec3 rgb) //purple
{
	vec3 outputCol;
	outputCol.x= ChannelBlend_Exclusion(rgb.x, 21.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 59.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 7.0/256.0);
	return outputCol;
}

vec3 AdjustforJigsaw_Autumn(vec3 rgb) // BLUE
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x, 16.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 5.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 99.0/256.0);
	return outputCol;
}
vec3 AdjustforJigsaw_Winter(vec3 rgb) //copper
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x, 9.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 62.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 103.0/256.0);
	return outputCol;
}

vec4 FUNCNAME(vec2 tc)
 {
    vec4 textureColor = INPUT(tc);
    vec4 fragOutCol;
	vec2 uv = tc;
    vec4 inColor = INPUT( uv );
	vec3 col = vec3(0.0);
	float W = iResolution.x;
	float H = iResolution.y;
	
	float whiteGap = 0.00325;
	float colorGapX = 0.33125;
	float colorGapX2 = 2.0*colorGapX;
	float whiteGapY = whiteGap*W/H;
	float colorGapY = (1.0 - whiteGapY)/2.0;
	
	vec3 temp; 
	
	col.xyz =AdjustforJigsaw_Summer(inColor.xyz);

	uv = vec2(uv.x, uv.y);
	if( uv.y >  0.605898 && uv.x > 0.318318)
		col.xyz = vec3(1.0); 
	if( uv.y >  0.605898 + whiteGapY && uv.x > 0.318318 + whiteGap)
		col.xyz = AdjustforJigsaw_Winter(inColor.xyz); 
	if( uv.y >  0.605898&& uv.x > 0.318318 - whiteGap && uv.x < 0.318318 )
	{
		temp = vec3(0.6/whiteGap*(uv.x - 0.318318 + whiteGap) + 0.1);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
	}
	
	
	if( uv.x >  0.4474 && uv.y < 0.654)
		col.xyz = vec3(1.0); 
	if( uv.x > 0.4474 + whiteGap && uv.y < 0.654 - whiteGapY)
		col.xyz = AdjustforJigsaw_Spring(inColor.xyz); 
	if(  uv.x < 0.4474 && uv.x > 0.4474 -  whiteGap  && uv.y < 0.654)
	{
		temp = vec3(0.6/whiteGap*(uv.x -  0.4474 + whiteGap) + 0.1);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
	}
	
	if( uv.y <  0.4210526 && uv.x < 0.465035)
		col.xyz = vec3(1.0); 
	if( uv.y <  0.4210526 - whiteGapY && uv.x < 0.465035 - whiteGap)
		col.xyz = AdjustforJigsaw_Autumn(inColor.xyz); 
	if( uv.y <  0.4210526 && uv.x > 0.465035 && uv.x < 0.465035 + whiteGap)
	{
		temp = vec3(-0.6/whiteGap*(uv.x - 0.465035 - whiteGap) + 0.1);
		col.xyz = ChannelBlend_Exclusion(col.xyz,temp);
	}
	
	return vec4(inColor.rgb, inColor.a)*(1.0 - intensity) + vec4(col.rgb, inColor.a)*intensity;
 }
 